#include <p30fxxxx.h>
#include <outcompare.h>

/* These devices support OutputCompare 3 and OutputCompare 4 */
#if defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/*************************************************************************
*    Function Name:  SetPulseOC3                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/

void SetPulseOC3(unsigned int pulse_start, unsigned int pulse_stop)
{   

    /* check if OC is in NON PWM Mode. */
    if( (OC3CONbits.OCM & 0x06) != 0x06) 
    {
        OC3R = pulse_start; /* assign pulse_start to Main Register */
        OC3RS = pulse_stop; /* assign pulse_stop to Secondary Register */
    }
}

#endif
